<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CarsShowRoom extends Model 
{

    protected $table = 'cars_show_rooms';
    public $timestamps = true;
    protected $fillable = array('id', 'name_ar', 'name_en', 'description_ar', 'description_en', 'record_number', 'logo', 'active', 'availablity', 'day_off_id', 'country_id', 'timestamps');

    public function contact()
    {
        return $this->morphOne('App\Models\Contact', 'contactable');
    }

    public function reviews()
    {
        return $this->morphToMany('App\Models\User', 'reviewable');
    }

    public function favourites()
    {
        return $this->morphToMany('App\Models\User', 'favouriable');
    }

    public function work_time()
    {
        return $this->morphOne('App\Models\WorkTime', 'workable');
    }

    public function cars()
    {
        return $this->morphToMany('App\Models\Car', 'carable');
    }

    public function check_reservations()
    {
        return $this->morphToMany('User', 'checkable');
    }

    public function categories()
    {
        return $this->morphToMany('App\Models\Category', 'categorizable');
    }

    public function policies()
    {
        return $this->morphMany('App\Models\Policy', 'policiable');
    }

    public function show_rooms()
    {
        return $this->morphToMany('App\Models\Car', 'carable');
    }

    public function day_offs()
    {
        return $this->hasMany('App\Models\DayOffs');
    }

    public function country()
    {
        return $this->belongsTo('App\Models\Country');
    }

}